<?php
$title = "Fund Transfer Report";
include 'header.php';
//$uid = $_SESSION['userid'];
//if (!isset($_SESSION['e_wallet']) && empty($_SESSION['e_wallet'])) {
//    redirect('./transaction_password.php?url=fund_transfer.php');
//}
//otp_authenticate("fund_transfer.php");
?>


<div class="container-fluid">

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Fund Transfer Report</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="javascript:void(0);">Home </a></li>
                    <li class="breadcrumb-item"><a href="javascript:void(0);">Payments</a></li>
                    <li class="breadcrumb-item active">Fund Transfer Reports</li>
                </ol>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <?php echo getMessage(); ?>
                    <div class="card-body">
                        <form class="form-inline" id="search-form" >
                            <div class="form-group">
                                <label class="form-control" for="from_login_id"> From User: </label>
                                <input type="text" class="form-control"  placeholder="Enter userId" name="from_login_id" id="from_login_id" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="login_id"> To User: </label>
                                <input type="text" class="form-control"  placeholder="Enter to userId" name="login_id" id="login_id" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="status">Wallet Type: </label>
                                <select name="status" id="status" class="form-control">
                                    <option value="">All</option>
                                    <option value="0">Fund Wallet</option>
                                    <option value="1">Payout Wallet</option>
                                </select>
                            </div>&nbsp;&nbsp;
                            <div class="form-group " >
                                <label class="form-control" for="from_date"> From Date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date"  id="from_date" autocomplete="off">
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control"  for="to_date"> To date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date"  id="to_date" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="amount"> Amount: </label>
                                <input type="number" class="form-control"  placeholder="Amount" name="amount" id="amount" step=".01" />
                            </div>&nbsp;&nbsp;
                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>
                    </div>
                    <table class="table table-striped table-bordered table-hover " id="datatable-ajax-page" style="border-collapse: collapse; border-spacing: 0; width: 100%;" >
                        <thead>
                            <tr>
                            <tr>
                                <th>S.No</th>
                                <th>From User</th>
                                <th>To User</th>
                                <th>Amount</th>
                                <th>Datetime</th>
                                <th>Fund Type</th>
                                <th>Wallet Type</th>
                                <th>Description</th>
                            </tr>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="3" class="text-right">Total</td>
                                <td colspan="5" class="text-left" id="tfootTotal">  </td>
                            </tr> 
                        </tfoot>
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
</div>
<script>
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "report/report_fund_transfer_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                "dataSrc": function (json) {
                    $("#tfootTotal").text(json.total);
                    return json.data;
                },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "from_user"},
                {"data": "to_user"},
                {"data": "amount"},
                {"data": "datetime"},
                {"data": "fund_type"},
                {"data": "status"},
                {"data": "description"},
            ],
        });
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        table.on('xhr', function () {
            start = table.ajax.json().start;
        });
    });
   
</script>

<?php include('footer.php'); ?>
