<?php
$title = "EMI Report";
include 'header.php';
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">EMI Report</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <!--<li class="breadcrumb-item"><a href="#">Webinar</a></li>-->
                    <li class="breadcrumb-item active">EMI Report</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end row -->
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <?php echo getMessage(); ?>
<!--                    <div class="card-body">
                        <form class="form-inline" id="search-form" >
                            <div class="form-group">
                                <label class="form-control" for="login_id"> UserId: </label>
                                <input type="text" class="form-control"  placeholder="Enter uid" name="login_id" id="login_id" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group " >
                                <label class="form-control" for="from_date"> From Date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date"  id="from_date" autocomplete="off">
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control"  for="to_date"> To date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date"  id="to_date" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="name"> Name: </label>
                                <input type="name" class="form-control" id="name" placeholder="Enter name" name="name">
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="txn_type"> Type: </label>
                                <select name="category" id="txn_type" class="form-control">
                                    <option value="">All</option>
                                    <option value="website">Website Webinar</option>
                                    <option value="customer">Customer Webinar</option>
                                </select>
                            </div>&nbsp;&nbsp;                         
                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>
                    </div>-->
                    <table class="table table-striped table-bordered table-hover dt-responsive" id="datatable-ajax-page" style="border-collapse: collapse; border-spacing: 0; width: 100%;" >
                        <thead>
                            <tr>
                            <tr>
                                <th>S.No.</th>
                                <th> EMI Amount </th>
                                <th>No. of Total EMI</th>
                                <th> EMI Date </th>
                                <th style="width: 25%;">Action</th>
                            </tr>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->



</div> <!-- container-fluid -->
<script type="text/javascript">
       var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "report/user_emi_payment_report_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                "dataSrc": function (json) {
                    $("#tfootTotal").text(json.total);
                    return json.data;
                },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "emi_amount"},
                {"data": "emi_number"},
                {"data": "emi_date"},
                {"data": "id",
                    "render": function (data, type, full, meta) {
                        return '<a href="view_emi_user.php?id=' + full.id + '" class="btn btn-primary" target="_blank">'+ " View "+'</a> ';
                    }},

            ],
        });
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        table.on('xhr', function () {
            start = table.ajax.json().start;
        });
    });


function myFunction() {
var r = confirm("Are you sure you want to delete?");
if (r == false) {
   return false;
}else{
    return true;
}
}
</script> 
<?php include 'footer.php'; ?>