<?php
$title = "Users KYC Doc Report";
include 'header.php';
//include_once('lib/ps_pagination.php');
?>
<!--<h1>User Login Details</h1>-->
<?php echo getMessage(); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <?php echo getMessage(); ?>
                <h4 class="page-title">Users KYC Doc Report</h4>
                <ol class="breadcrumb">
                   <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Users</a></li>
                    <li class="breadcrumb-item active">Users KYC Doc Report</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end row -->
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    
                    <div class="card-body">
                        <form class="form-inline" id="search-form" >
                            <div class="form-group " >
                                <label class="form-control" for="login_id"> UserId: </label>
                                <input type="text" class="form-control" id="login_id" placeholder="Enter login id" name="login_id">
                            </div>
                            <div class="form-group " >
                                <label class="form-control " > From Date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date" autocomplete="off">
                            </div>&nbsp;
                            <div class="form-group">
                                <label class="form-control "> To date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date" autocomplete="off" >
                            </div>
                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>
                    </div>
                    <table class="table table-striped table-bordered table-hover  " id="datatable-ajax-page" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>Name</th>
                                <th>Doc Type</th>
                                <th>Date</th>
                                <th>Image</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->



</div> <!-- container-fluid -->
<script type="text/javascript">
//    var columnMetadataAll = [{"data": "sno", "title": "S.No."}, {"data": "user_name", "title": "User"}, {"data": "datetime", "title": "Date"}, {"data": "ip", "title": "IP Address"}];
//    var urlAll = "./report/report_login_json.php";
//    var table = null;
//
//    $(document).ready(function () {
//        table = loadDataTable('.datatable-ajax', urlAll, columnMetadataAll, false, 2);
//
//        $("#search-form").submit(function (e) {
//            table.ajax.reload();
//            e.preventDefault(); // avoid to execute the actual submit of the form.
//        });
//        $('.datatable-ajax tbody').on('click', 'tr', function () {
//            var data = table.row(this).data();
//            //window.location ='/'+moduleCode+'/view/?id='+data.id;
//        });
//    });

    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "./report/kyc_doc_report_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            //"lengthMenu": [[100, 500, 1000, 2000, -1], [100, 500, 1000, 2000, "All"]],
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "user_name"},
                {"data": "doc_type"},
                {"data": "create_date"},
                {"data": "uid",
                    "render": function (data, type, full, meta) {
                        return '<a href="../static/backend/user-resource/uploads/kyc_doc/' + full.file_name + '" target="_blank"><img src="../static/backend/user-resource/uploads/kyc_doc/' + full.file_name + '" width="100px" /></a>';
                    }
                },
                {"data": "uid",
                    "render": function (data, type, full, meta) {
                        var html = '';
                        if(full.status == 1){
                            html = '<b class="text-success">APPROVED</b>';
                        } else if(full.status == 2){
                            html = '<b class="text-danger">REJECTED</b>';
                        } else {
                            html += ' <a href="./kyc_edit.php?uid=' + full.uid + '" class=btn-default>Edit</a> ';
                            html += ' <button onclick="processFieldUpdate(' + full.id + ', \'' + full.login_id + '\' , \'status\' ,1);" class="btn btn-success" style="margin:2px;">APPROVE</button> ';
                            html += ' <button onclick="processFieldUpdate(' + full.id + ', \'' + full.login_id + '\' , \'status\' ,2);" class="btn btn-success" style="margin:2px;">REJECT</button> ';
                        } 
                        return html;
                    }
                },
//                {"data": "service"},
//                {"data": "net_amount"},
//                {"data": "uid",
//                    "render": function (data, type, full, meta) {
//                        return '<button onclick="processStatus(' + full.recid + ', \'' + full.description + '\', \'' + full.name + '\', \'' + full.email + '\', \'' + full.mobile + '\', \'' + full.account_holder_name + '\', \'' + full.bank_name + '\', \'' + full.branch_name + '\', \'' + full.account_number + '\', \'' + full.ifsc + '\');" class="btn btn-primary">' + 'View Pay Details' + '</buton>';
//                    }
//                },
            ],
        }
        );

        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });

        table.on('xhr', function () {
            start = table.ajax.json().start;

        });
    });

function processFieldUpdate(id, login_id, field_name, field_value) {
        var r = confirm("Do you want to update status of this id " + login_id);
        if (r) {
            $.get("process_field_update.php", {table_name: 'kyc_doc', where_field_name: 'id', id: id, field_name: field_name, field_value: field_value}, function (data) {
                alert(data);
                location.reload();
            });
        }
    }


</script> 

<?php include 'footer.php'; ?>