<?php
$title = "Payout Report";
include 'header.php';
?>

<div class="container-fluid">

    
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Payout</h4>
                <ol class="breadcrumb">
                      <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Payments</a></li>
                    <li class="breadcrumb-item active">Payout</li>
                </ol>

                <!--                                    <div class="state-information d-none d-sm-block">
                                                        <div class="state-graph">
                                                            <div id="header-chart-1"></div>
                                                            <div class="info">Balance $ 2,317</div>
                                                        </div>
                                                        <div class="state-graph">
                                                            <div id="header-chart-2"></div>
                                                            <div class="info">Item Sold 1230</div>
                                                        </div>
                                                    </div>-->
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <?php echo getMessage(); ?>
                    <form class="form-inline" id="search-form" action="">
                        <div class="form-group " >
                            <label class="form-control" for="login_id"> UserId: </label>
                            <input type="text" class="form-control" id="login_id" placeholder="Enter login id" name="login_id">
                        </div>&nbsp;&nbsp;
                        <div class="form-group " >
                            <label class="form-control" for="name"> User Name: </label>
                            <input type="text" class="form-control" id="login_id" placeholder="Enter name" name="name">
                        </div>&nbsp;&nbsp;
                        <div class="form-group">
                                <label class="form-control" for="txn_type"> Type: </label>
                                <select name="txn_type" id="txn_type" class="form-control" >
                                    <option value="">All</option>
                                    <?php foreach ($master_wallet_array[$master_payout_wallet_id]['txn_type_array'] as $txn_type) {
                                        ?>
                                        <option value="<?php echo $txn_type; ?>"><?php echo $master_income_type_array[$txn_type]; ?></option>
                                    <?php } ?>
                                </select>
                            </div>&nbsp;&nbsp;
                        <div class="form-group " >
                            <label class="form-control " > From Date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date" autocomplete="off">
                        </div>&nbsp;&nbsp;
                        <div class="form-group">
                            <label class="form-control "> To date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date" autocomplete="off" >
                        </div>&nbsp;&nbsp;
                        
                            <div class="form-group">
                        <label class="form-control" for="status">Status </label>
                        <select name="status" id="income_type" class="form-control">
                            <option value="">All Status User</option>
                            <option value="0">Active User</option>
                            <option value="1">Blocked User</option>
                                                               
                        </select>&nbsp;&nbsp;
                            </div>

                        <button type="submit" class="btn btn-primary" id="submit">Search</button><br><br><br>
                    </form>
                    <form action="./process_payout_multiple.php" method="post">
                        <input type="hidden"  name="txn_type_m" id="txn_type_m"  >
                    <table class="table mb-0" id="datatable-ajax-page">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th><input type="checkbox"  onchange="checkUncheckAllPayout(this)"/></th>
                                <th>User</th>
                                <th>Amount</th>
                                <th>TDS (<?php echo $master_tds_rate; ?>%)</th>
                                <th>Service Charge (<?php echo $master_service_rate; ?>%)</th>
                                <th>Net Amount</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="3" class="text-right">Total</th>
                                <th id="tfootTotal1" class="text-left"></th>
                                <th id="tfootTotal2" class="text-left"></th>
                                <th id="tfootTotal3" class="text-left"></th>
                                <th id="tfootTotal4" class="text-left"></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                        <h3>Multiple Payout</h3>
                    <div class="form-group row">
                        <label for="description" class="col-sm-2 col-form-label">Payment description<span>*</span></label>
                        <input type="text" class="form-control" name="description" id="uid" required="required" maxlength="255"  style="width:300px;" >
                    </div>
                    <div class="form-group">
                        <div>
                            <button name="submit" type="submit" id="submit" value="Submit" class="btn btn-primary waves-effect waves-light">Submit</button>
                        </div>
                    </div>
                </form>
                    <?php //echo $pager->renderFullNav();     ?>  
                </div>
            </div>
        </div> <!-- end col -->
    </div>
    <!--table content ends here-->
</div>
<!-- end row -->



<script type="text/javascript">
//$(function() {
// $( ".dialog" ).dialog({ autoOpen: false, minWidth: 550 });
//});

var master_min_payment_amount_request = <?php echo $master_min_payment_amount_request; ?>;
var master_max_payment_amount_request = <?php echo $master_max_payment_amount_request == -1 ? 10000000 : $master_max_payment_amount_request; ?>;
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "./report/payout_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                "dataSrc": function ( json ) {
                //Make your callback here.
                //alert("Done! "+json.recordsTotal);
                $("#tfootTotal1").text(json.total);
                    $("#tfootTotal2").text(json.tds_total);
                    $("#tfootTotal3").text(json.service_total);
                    $("#tfootTotal4").text(json.net_total);
                return json.data;
                },
            },
            "columnDefs": [
    { "orderable": false, "targets": 1 }
  ],
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            //"lengthMenu": [[100, 500, 1000, 2000, -1], [100, 500, 1000, 2000, "All"]],
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "uid",
                    "render": function (data, type, full, meta) {
                        return '<input type="checkbox" name="uid_array[]" value="'+full.uid+'" class="uid_checkbox" >';
                    }
                },
                {"data": "name",
                    "render": function (data, type, full, meta) {
                        return full.name + ' (' + full.login_id + ')';
                    }},
                /* { "data": "parentRoleId" }, */
                {"data": "wallet"},
                {"data": "tds"},
                {"data": "service"},
                {"data": "net_amount"},
                {"data": "uid",
                    "render": function (data, type, full, meta) {
                        var max_amount = master_max_payment_amount_request < full.wallet ? master_max_payment_amount_request : full.wallet;
                        var html = '';
                        html += '<span id="rowPaymentTD-' + full.sno + '">'
                                +'<input type="number" name="amount_array[' + full.uid + ']" id="amount-' + full.sno + '"  max="'+max_amount+'" value="'+max_amount+'" step=".01" placeholder="Enter Amount" style="margin:2px;" /><br/>'
                                +'<input type="text" name="description" id="description-' + full.sno + '" placeholder="Transaction details" style="margin:2px;" />'
                                +' <button type="button" class="btn btn-primary" onclick="processStatus(' + full.uid + ', \'' + full.login_id + '\', \'' + full.sno + '\');" style="margin:2px;" >' + 'Make Payment' + '</button>'
                                +'</span>';
                        return html;
                    }
                },
            ],
        }
        );
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            $('#txn_type_m').val($('#txn_type').val());
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        
        table.on('xhr', function () {
	    start = table.ajax.json().start;

        });
    });



    function processStatus(uid, login_id, rowCounter) {
        // $( "#"+domId).dialog( "open" );
        if ($("#description-" + rowCounter).val() == '') {
            alert("Please enter transaction details!");
            return;
        }
        var r = confirm("Do you want make payment of user ID " + login_id);
        if (r) {
            var txn_type = $("#txn_type").val();
            $.post("process_payout.php", {uid: uid, description: $("#description-" + rowCounter).val(), amount: $("#amount-" + rowCounter).val(), txn_type: txn_type},
            function (data) {
                var htmlMessage = data.status ? '<span style="color:green">Paid</span>' : '<span style="color:red">ERROR</span>';
                $("#rowPaymentTD-" + rowCounter).html(htmlMessage);
            }, 'json');
        }
    }
    function checkUncheckAllPayout(thisObj) {
        if ($(thisObj).is(':checked')) {
            $(".uid_checkbox").prop('checked', true);
        } else {
            $(".uid_checkbox").prop('checked', false);
        }



    }
</script>
<?php include 'footer.php'; ?>