<?php
$title = "PIN Package";
include 'header.php';
?>


<div class="container-fluid">
    <?php echo getMessage(); ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Add PIN Package</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Pin</a></li>
                    <li class="breadcrumb-item active">PIN Package</li>
                </ol>


            </div>
        </div>
    </div>
    <!-- end row -->

    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <form name="form" id="pin_package_form" action="pin_package_model.php" method="post" enctype="multipart/form-data">

                        <div class="form-group  row">
                            <label class="col-sm-2 col-form-label" for="package_amount">Package Amount <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="number" name="package_amount" id="package_amount" onkeyup="$('#package_name').val('Package '+this.value);$('#bv_amount').val(this.value);" required="required"  min="0" step=".01" autocomplete="off" />
                            </div>
                        </div>
                        
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="package_name">Package Name <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="text" name="package_name" id="package_name" required="required" maxlength="100">
                            </div>
                        </div>
                        
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="bv_amount">P.V. Amount <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="number" name="bv_amount" id="bv_amount" required="required"  min="0" step=".01" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="pin_length">PIN Length<span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="number" name="pin_length" id="package_name" required="required" value="8" min="5" max="12"  step="1" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="type" value="<?php echo isset($_GET['type']) ? $_GET['type'] : ''; ?>" />
                                <button name="submit" type="submit" id="submit" value="Generate" class="btn btn-primary waves-effect waves-light">
                                    Create
                                </button>
                                
                        </div>

                    </form>
                </div>

            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->


</div> <!-- container-fluid -->

<div class="container-fluid">

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title"><B>PIN Package Report</b></h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Pin</a></li>
                    <li class="breadcrumb-item active">Pin</li>
                </ol>
                <section id="comments">
                    <form class="form-inline" id="search-form" action="">
                        <div class="form-group " >
                            <label class="form-control" for="package_name"> Package Name: </label>
                            <input type="text" class="form-control"  placeholder="Enter package name" name="package_name">
                        </div>&nbsp;
                        
                        <div class="form-group " >
                            <label class="form-control " > From Date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date" autocomplete="off">
                        </div>&nbsp;
                        <div class="form-group">
                            <label class="form-control "> To date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date" autocomplete="off" >
                        </div>&nbsp;
                        <div class="form-group " >
                            <label class="form-control" for="package_amount"> Package Amount: </label>
                            <input type="text" class="form-control"  placeholder="Enter package amount" name="package_amount">
                        </div>&nbsp;
                        
                        <button type="submit" class="btn btn-primary" id="submit">Search</button><br><br><br>
                    </form>
                </section>

            </div>
        </div>
    </div>
        <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <?php echo getMessage(); ?>
<!--                    <h4 class="mt-0 header-title">Downline Report</h4>-->
                    <div class="card-body">
                    </div>
                    <table class="table table-striped table-bordered table-hover  datatable-ajax" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
<!--                        <tfoot align="right">
                            <tr><th style="text-align: left;">Total</th><th></th><th style="text-align: left;"></th><th></th><th></th></tr>
                        </tfoot>-->
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
        <!--table content ends here-->
        
</div>




</div> <!-- container-fluid -->
<script type="text/javascript">
    var columnMetadataAll = [{"data": "sno", "title": "S.No."}, {"data": "package_name", "title": "Package Name"}, {"data": "package_amount", "title": "Package Amount"}, {"data": "bv_amount", "title": "P.V. amount"}, {"data": "pin_length", "title": "PIN Length"}, {"data": "datetime", "title": "Date"} ];
    var urlAll = "./report/report_pin_pacakge_json.php";
    var table = null;

    $(document).ready(function () {
        table = loadDataTable('.datatable-ajax',urlAll, columnMetadataAll);

        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        $('.datatable-ajax tbody').on('click', 'tr', function () {
            var data = table.row(this).data();
            //window.location ='/'+moduleCode+'/view/?id='+data.id;
        });
    });

//function autofill_form(fieldText){
//    $("#package_name").val('Package '+this.value);$("#bv_amount").val(this.value);
//}

</script>
<?php include('footer.php'); ?>


<?php
$title = "Pin Package";
include 'header.php';
?>
