<?php
$title = "Product List";
include 'header.php';
?>

<div class="container-fluid">

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Product List</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Inventory</a></li>
                    <li class="breadcrumb-item active">Product List</li>

                </ol>

            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <form class="form-inline" id="search-form" action="">
                        <div class="form-group">
                                <label class="form-control" for="pcode"> Product Code: </label>
                                <input type="text" class="form-control"  placeholder="Enter pcode" name="pcode" id="pcode"  >
                        </div>&nbsp;
                        <div class="form-group" >
                            <label class="form-control " > From Date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date" autocomplete="off">
                        </div>&nbsp;
                        <div class="form-group">
                            <label class="form-control "> To date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date" autocomplete="off" >
                        </div>
                        <div class="form-group">
                                <label class="form-control" for="pname"> Product Name: </label>
                                <input type="text" class="form-control"  placeholder="Enter pname" name="pname" id="pname"  >
                        </div>&nbsp;
                        <button type="submit" class="btn btn-primary" id="submit">Search</button><br><br><br>
                    </form>


                    <table class="table mb-0 table-bordered table-striped" id="datatable-ajax-page">
                        <thead>
                            <tr>
                                <th>
                                    P. ID
                                </th>
                                <th>
                                    P Code
                                </th>
                                <th>
                                    P Name
                                </th>
                                <th> P. Cost  </th>
                                <th> PV </th>
                                <th> MRP  </th>
                                <th>Quantity Available</th>
                                <th>GST</th>
                                <th>IGST</th>
                                <th>HSN/SAC</th>
                                <th>Edit</th>
                                <th> Delete </th>
                            </tr>
                        </thead>
                        <!--<tfoot>-->
                        <!--    <tr>-->
                        <!--        <td colspan="7" class="text-right">Total</td>-->
                        <!--        <td class="text-left" id="tfootTotal">  </td>-->
                        <!--        <td class="text-left" id="tfootTotal1">  </td>-->
                        <!--        <td class="text-left" id="tfootTotal2">  </td>-->
                        <!--        <td></td>-->
                        <!--        <td></td>-->
                        <!--    </tr> -->
                        <!--</tfoot>-->
                    </table>
<?php //echo $pager->renderFullNav();       ?>  
                </div>
            </div>
        </div> <!-- end col -->
    </div>
    <!--table content ends here-->
</div>
<script type="text/javascript">
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            ajax: {
                "url": "./report/product_list_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {

                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                dataSrc: function (json) {
//                    $("#tfootTotal").text(json.total_pcost);
//                    $("#tfootTotal1").text(json.total_pv);
//                    $("#tfootTotal2").text(json.total_quantity);
                    return json.data;
                },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            //"lengthMenu": [[100, 500, 1000, 2000, -1], [100, 500, 1000, 2000, "All"]],
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "pid"},
//                {"title": "User", "data": "name",
//                    "render": function (data, type, full, meta) {
//                        return '<a href="edit_profile.php?uid=' + full.uid + '">' + full.login_id + '</a>';
//                    }},
                /* { "data": "parentRoleId" }, */
//                {"title": "User", "data": "name",
//                    "render": function (data, type, full, meta) {
//                        return '<a href="user_login_process.php?uid=' + full.uid + '" title="Login this user" target="_blank">' + full.name + '</a>';
//                    }},
                {"data": "pcode"},
                {"data": "pname"},
                {"data": "pcost"},
                {"data": "pv"},
                {"data": "mrp"},
                {"data": "quantity_available"},
                {"data": "gst"},
                {"data": "igst"},
                {"data": "hsn_code"},
                
                  // "quantity" },
//                {"data": "pid",
//                    render": function (data, type, full, meta) {
//                    return '<a href="product_edit.php?pid='+full.pid+'">'+'</a>';
//                }},
          
            {"data": "pid",
                    "render": function (data, type, full, meta) {
                        return '<a href="product_edit.php?pid=' + full.pid + '" class="btn btn-primary">'+ "edit"+'</a>';
                    }},
                {"data": "pid",
                    "render": function (data, type, full, meta) {
                        return '<a href="delete_product.php?pid=' + full.pid + '" class="btn btn-primary">'+ "delete"+'</a>';
                    }},
            ],
        }
        );
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });

        table.on('xhr', function () {
            start = table.ajax.json().start;

        });
    });


   
</script>
<?php
include('footer.php');
?>