<?php
$title = "Product Package";
include 'header.php';
?>
<div class="container-fluid">
    <?php echo getMessage();?>

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Product Package Report</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Pin</a></li>
                    <li class="breadcrumb-item active">Product Package</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end row -->

    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <form name="form" id="form" action="product_package_model.php" method="post" enctype="multipart/form-data">
                        <div class="form-group row">
                            <!--                                            <label for="example-text-input" class="col-sm-2 col-form-label">Text</label>-->
                            <label class="col-sm-2 col-form-label" for="pin_number_id">User</label>
<!--                                            <label class="col-sm-2 col-form-label" for="dob"> Name<span>*</span></label>-->
                            <div class="col-sm-10">
                                <select class="custom-select" onchange="setFieldValue(this)" id="pin_number_id" name="pin_number_id">
                                    <option value="" disabled="disabled" selected="selected">-- Select user --</option>
                                    <?php
                                    $result_pin_package = mysqli_query($connection,"SELECT u.*,  p.amount as amount, p.recid as recid FROM user u INNER JOIN dynamicpinnumber p ON u.uid = p.uid  WHERE p.uid !=0 AND p.uid IS NOT NULL AND p.recid NOT IN (SELECT pin_number_id FROM product_package) ORDER BY u.login_id");
                                    while ($pin_row = mysqli_fetch_object($result_pin_package)) {
                                        ?>
                                        <option value="<?php echo $pin_row->recid; ?>" data-uid="<?= $pin_row->uid; ?>" data-package-amount="<?= $pin_row->amount; ?>" data-name="<?= $pin_row->name; ?>" data-mobile="<?= $pin_row->mobile; ?>" data-address="<?= $pin_row->address; ?>" data-city="<?= $pin_row->city; ?>" data-state="<?= $pin_row->state; ?>" data-pin-code="<?= $pin_row->pincode; ?>" ><?php echo $pin_row->login_id . " ($pin_row->name) "; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                                <input type="hidden" name="uid" value="" id="uid" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="package_name">Package Name <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="text" name="package_name" id="package_name" value="" required="required" maxlength="250">

                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="product_name">Product Name <span>*</span></label>

                            <div class="col-sm-10">

                                <input class="form-control" type="text" name="product_name" id="product_name" value="" required="required" maxlength="250">

                            </div>

                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="receiver_name">Receiver Name <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" <input type="text" name="receiver_name" id="receiver_name" value="" required="required" maxlength="250">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="address">Address <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="text" name="address" id="address" value="" maxlength="250">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="city">City <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="text" name="city" id="city" value="" maxlength="250">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="state">State <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="text" name="state" id="state" value="" maxlength="250">
                            </div>
                        </div>
                        
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="mobile">Mobile <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="text" name="mobile" id="mobile" value="" maxlength="250">
                            </div>
                        </div>    <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="pin_code">Pin Code <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="text" name="pin_code" id="pin_code" value="" maxlength="250">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="courier_name">Courier <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="text" name="courier_name" id="courier_name" value="" maxlength="250">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="tracking_number">Tracking no. <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="text" name="tracking_number" id="tracking_number" value="" maxlength="250">
                            </div>
                        </div>
                        <div class="form-group">
                            <div>
<!--                                      <input style="position: relative; left: 160px;" name="submit" type="submit" id="submit" value="Save">
                                -->
                                <button name="submit" type="submit" id="submit" value="Send Package" class="btn btn-primary waves-effect waves-light">
                                    Submit
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->


</div> <!-- container-fluid -->


<!--table view new template--->
<div class="container-fluid">

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Product Package</h4>
                 <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Pin</a></li>
                    <li class="breadcrumb-item active">Product Package</li>
                </ol>

                <!--                                    <div class="state-information d-none d-sm-block">
                                                        <div class="state-graph">
                                                            <div id="header-chart-1"></div>
                                                            <div class="info">Balance $ 2,317</div>
                                                        </div>
                                                        <div class="state-graph">
                                                            <div id="header-chart-2"></div>
                                                            <div class="info">Item Sold 1230</div>
                                                        </div>
                                                    </div>-->
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-20">
                <div class="card-body">

                    <!--                                        <h4 class="mt-0 header-title">Basic example</h4>
                                                            <p class="text-muted m-b-30">For basic styling—light padding and
                                                                only horizontal dividers—add the base class <code>.table</code> to any
                                                                <code>&lt;table&gt;</code>.
                                                            </p>-->

                    <table class="table mb-0 datatable">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>User</th>
                                <th>Package Name</th>
                                <th>Product Name</th>
                                <th>Receiver Name</th>
                                <th>Mobile</th>
                                <th>Tracking No.</th>
                                <th>Courier</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <?php
                        $query = "SELECT p.*,u.name as name, u.login_id as login_id FROM user u INNER JOIN product_package p ON u.uid = p.uid  ORDER BY p.datetime DESC ";
//                        echo $query;
                        $result = mysqli_query($connection, $query);
                        if (mysqli_num_rows($result) > 0) {
                            
                            ?>
                            <tbody>
                                <?php
                                $i = 1;
//                                echo $i;
                                while ($row = mysqli_fetch_object($result)) {
                                    ?>
                                    <tr>
                                        <td><?php echo $i++; ?></td>
                                        <td><?php echo $row->name . " ($row->login_id)"; ?></td>
                                        <td><?php echo $row->package_name; ?></td>
                                        <td><?php echo $row->product_name; ?></td>
                                        <td><?php echo $row->receiver_name; ?></td>
                                        <td><?php echo $row->mobile; ?></td>
                                        <td><?php echo $row->tracking_number; ?></td>
                                        <td><?php echo $row->courier_name; ?></td>
                                        <td><?php echo date("d/m/Y h:i A", strtotime($row->datetime));?></td>  </tr>
                                    <?php
                                }
                            }
                            ?>
                        </tbody>
                    </table>
                    <?php //echo $pager->renderFullNav();      ?>  
                </div>
            </div>
        </div> <!-- end col -->
    </div>
    <!--table content ends here-->
</div>
<!-- end row -->


<script>
    function setFieldValue(thisObj) {
        var dataObj = $("#pin_number_id").find(':selected');
        $("#uid").val(dataObj.data("uid"));
        $("#package_name").val("Package " + dataObj.data("package-amount"));
        $("#receiver_name").val(dataObj.data("name"));
        $("#address").val(dataObj.data("address"));
        $("#city").val(dataObj.data("city"));
        $("#state").val(dataObj.data("state"));
        $("#pin_code").val(dataObj.data("pin-code"));
        $("#mobile").val(dataObj.data("mobile"));
    }
</script>

<?php include 'footer.php'; ?>