<?php
$title = "Level Income Report";
include 'header.php';
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Level Income Report</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Reports</a></li>
                    <li class="breadcrumb-item active">Level Income Report</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end row -->
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <?php echo getMessage(); ?>
                    <div class="card-body">
                        <form class="form-inline" id="search-form" >
                            <div class="form-group">
                                <label class="form-control" for="login_id"> UserId: </label>
                                <input type="text" class="form-control"  placeholder="Enter uid" name="login_id" id="login_id" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group " >
                                <label class="form-control" for="from_date"> From Date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date"  id="from_date" autocomplete="off">
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control"  for="to_date"> To date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date"  id="to_date" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="from_login_id">From UserId: </label>
                                <input type="text" class="form-control"  placeholder="Enter From UserId" name="from_login_id" id="from_login_id" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="level_number">Level number: </label>
                                <input type="number" class="form-control"  placeholder="Enter level number" name="level_number" id="level_number" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="status">Package: </label>
                                <select name="pid" id="pid" class="form-control">
                                    <option value="">All</option>
                                    <?php
                                    $result_pin_package = mysqli_query($connection, "SELECT id, package_name, package_amount, pin_length FROM pin_package ");
                                    while ($pin_type = mysqli_fetch_object($result_pin_package)) {
                                        if( !$master_is_zero_pin_package && $pin_type->id == 1) continue;
                                        ?>
                                        <option value="<?php echo $pin_type->id; ?>" >
                                            <?php echo $pin_type->package_name . " ($pin_type->package_amount) "; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="txn_type"> Txn Type: </label>
                                <select name="txn_type" id="txn_type" class="form-control">
                                    <option value="">All</option>
                                    <?php foreach ($GLOBALS['master_income_type_array'] as $income_type => $income_name) {
                                        if(in_array($income_type, array(1,5,25,26,27,28))){
                                        ?>
                                        <option value="<?php echo $income_type; ?>"><?php echo $income_name; ?></option>
                                    <?php }} ?>
                                </select>
                            </div>&nbsp;&nbsp;
                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>
                    </div>
                    <table class="table table-striped table-bordered table-hover " id="datatable-ajax-page" style="border-collapse: collapse; border-spacing: 0; width: 100%;" >
                        <thead>
                            <tr>
                                <th>S.No.</th>
                                <th>User</th>
                                <th>Amount</th>
                                <th>From User</th>
                                <th>Level</th>
                                <th>Package</th>
                                <th>PV</th>
                                <th>Txn Type</th>
                                <th>Datetime</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2" class="text-right">Total</td>
                                <td class="text-left" id="tfootTotal">  </td>
                                <td colspan="3" class="text-right"></td>
                                <td colspan="1" class="text-left" id="tfootTotal1">  </td>
                                <td colspan="2" class="text-right"></td>
                                
                            </tr> 
                        </tfoot>
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->



</div> <!-- container-fluid -->
<script type="text/javascript">
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "report/report_level_income_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                "dataSrc": function (json) {
                    $("#tfootTotal").text(json.total);
                    $("#tfootTotal1").text(json.total1);
                    return json.data;
                },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "user_name"},
                {"data": "amount"},
                {"data": "from_user"},
                {"data": "level_number"},
                {"data": "pin_package"},
                {"data": "pv_amount"},
                {"data": "txn_type"},
                {"data": "datetime"},
            ],
        });
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        table.on('xhr', function () {
            start = table.ajax.json().start;
        });
    });



</script> 
<?php include 'footer.php'; ?>