<?php
$title = "Payout Report";
include 'header.php';
?>

<div class="container-fluid">

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Payout Report</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Payment</a></li>
                    <li class="breadcrumb-item active">Payout Report</li>
                </ol>

                <!--                                    <div class="state-information d-none d-sm-block">
                                                        <div class="state-graph">
                                                            <div id="header-chart-1"></div>
                                                            <div class="info">Balance $ 2,317</div>
                                                        </div>
                                                        <div class="state-graph">
                                                            <div id="header-chart-2"></div>
                                                            <div class="info">Item Sold 1230</div>
                                                        </div>
                                                    </div>-->
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <form class="form-inline" id="search-form" action="">
                        <div class="form-group " >
                            <label class="form-control" for="login_id"> UserId: </label>
                            <input type="text" class="form-control" id="login_id" placeholder="Enter login id" name="login_id">
                        </div>&nbsp;&nbsp;

                        <div class="form-group " >
                            <label class="form-control " > From Date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date" autocomplete="off">
                        </div>&nbsp;&nbsp;
                        <div class="form-group">
                            <label class="form-control "> To date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date" autocomplete="off" >
                        </div><br>&nbsp;&nbsp;
                        <div class="form-group " >
                            <label class="form-control" for="name"> User Name: </label>
                            <input type="text" class="form-control" id="login_id" placeholder="Enter name" name="name">
                        </div>&nbsp;&nbsp;
                        <div class="form-group " >
                            <label class="form-control" for="hold_payment"> Payment: </label>
                            <select name="hold_payment" id="income_type" class="form-control">
                                <option value="">All Payment User</option>
                                <option value="0">Active Payment</option>
                                <option value="1">Hold Payment</option>
                            </select>
                        </div>&nbsp;&nbsp;
                        <div class="form-group " >
                            <label class="form-control" for="status">User Status </label>
                            <select name="status" id="income_type" class="form-control">
                                <option value="">All Status User</option>
                                <option value="0">Active User</option>
                                <option value="1">Blocked User</option>
                            </select>
                        </div> &nbsp;&nbsp;

                        <button type="submit" class="btn btn-primary" id="submit">Search</button><br><br><br>
                    </form>
                    <table class="table mb-0" id="datatable-ajax-page">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>User</th>
                                <th>Amount</th>
                                <th>TDS (<?php echo $master_tds_rate; ?>%)</th>
                                <th>Service Charge (<?php echo $master_service_rate; ?>%)</th>
                                <th>Net Amount</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="2" class="text-right">Total</th>
                                <th id="tfootTotal1" class="text-left"></th>
                                <th id="tfootTotal2" class="text-left"></th>
                                <th id="tfootTotal3" class="text-left"></th>
                                <th id="tfootTotal4" class="text-left"></th>

                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div>
    <!--table content ends here-->
</div>
<!-- end row -->



<script type="text/javascript">

    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "./report/payout_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                "dataSrc": function (json) {
                    //Make your callback here.
                    //alert("Done! "+json.recordsTotal);
                    $("#tfootTotal1").text(json.total);
                    $("#tfootTotal2").text(json.tds_total);
                    $("#tfootTotal3").text(json.service_total);
                    $("#tfootTotal4").text(json.net_total);
                    return json.data;
                },
            },
            "columnDefs": [
                {"orderable": false, "targets": 1}
            ],
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            //"lengthMenu": [[100, 500, 1000, 2000, -1], [100, 500, 1000, 2000, "All"]],
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "name",
                    "render": function (data, type, full, meta) {
                        return full.name + ' (' + full.login_id + ')';
                    }},
                /* { "data": "parentRoleId" }, */
                {"data": "wallet"},
                {"data": "tds"},
                {"data": "service"},
                {"data": "net_amount"},
            ],
        }
        );
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });

        table.on('xhr', function () {
            start = table.ajax.json().start;

        });
    });


</script>
<?php include 'footer.php'; ?>