<?php
$title = "Product Report";
include "header.php";
if(!isset ($_SESSION['fid'])) redirect('login.php');
?>


<div class="container-fluid">

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Product Purchase Report</h4>
               <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Purchase Report</a></li>
                        <li class="breadcrumb-item active">Product Report</li>
                    </ol>
                <!--                <div class="state-information d-none d-sm-block">
                                    <div class="state-graph">
                                        <div id="header-chart-1"></div>
                                        <div class="info">Balance $ 2,317</div>
                                    </div>
                                    <div class="state-graph">
                                        <div id="header-chart-2"></div>
                                        <div class="info">Item Sold 1230</div>
                                    </div>
                                </div>-->
            </div>
        </div>
    </div>
    <!-- end row -->


    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                <?php echo getMessage(); ?>
                    <div class="card-body">
<!--                        <form class="form-inline" id="search-form" >
                            <div class="form-group">
                                <label class="form-control" for="login_id"> UserId: </label>
                                <input type="text" class="form-control" id="login_id" placeholder="Enter login id" name="login_id">
                            </div>&nbsp;
                            <div class="form-group">
                                <label for="name"> Name: </label>
                                <input type="name" class="form-control" id="name" placeholder="Enter name" name="name">
                            </div>

                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>-->
                    </div>
                    <table class="table mb-0 table-bordered table-striped" id="datatable-ajax-page">
                        <thead>
                            <tr>
                                <th>S.no. </th>
                                <th>
                                    P. Code
                                </th>
                                <th>
                                    P. Name
                                </th>
                                <th>MRP</th>
                                <th>
                                    P. Cost
                                </th>
                                <th>
                                    Qty. avail
                                </th>
                                <th>B.V.</th>
                                
                                <th>Amount</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="4" class="text-right">Total</td>
                                <td class="text-left" id="tfootTotal">  </td>
                                <td class="text-left" id="tfootTotal1">  </td>
                                <td class="text-left" id="tfootTotal2">  </td>
                                <td class="text-left" id="tfootTotal3">  </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->



</div> <!-- container-fluid -->
<script type="text/javascript">
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "./report/product_report_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {

                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;

                    });
                },
                dataSrc: function (json) {
                    $("#tfootTotal").text(json.total_pcost);
                    $("#tfootTotal1").text(json.total_quantity);
                    $("#tfootTotal2").text(json.total_pv);
                    $("#tfootTotal3").text(json.total);
                    return json.data;
                },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            //"lengthMenu": [[100, 500, 1000, 2000, -1], [100, 500, 1000, 2000, "All"]],
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "pcode"},
                {"data": "pname"},
                {"data": "mrp"},
                {"data": "pcost"},
                {"data": "quantity"},
                {"data": "pv_amount"},
                {"data": "amount"},
                
            ],
        }
        );
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });

        table.on('xhr', function () {
            start = table.ajax.json().start;

        });
    });

</script>
<?php include 'footer.php'; ?>
<?php
include('footer.php');
?>