<?php
$title = "Stock Details Report";
include 'header.php';

?>

<div class="container-fluid">

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Stock Details report</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Inventory</a></li>
                    <li class="breadcrumb-item active">Stock Details Reports</li>

                </ol>

            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-20">
                <div class="card-body">

                    
                    <form class="form-inline" id="search-form" >
                            <div class="form-group">
                                <label class="form-control" for="name">Product Name: </label>
                                <input type="text" class="form-control" id="name" placeholder="Enter name" name="name">
                            </div>&nbsp;&nbsp;
                            <div class="form-group " >
                                <label class="form-control" for="from_date"> From Date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date"  id="from_date" autocomplete="off">
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control"  for="to_date"> To date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date"  id="to_date" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="module_id">Txn Type: </label>
                                <select name="module_id" id="module_id"  class="form-control">
                                     <option value="">All</option>
                                    <?php foreach ($GLOBALS['master_stock_txn_type_array'] as $txn_type => $txn_name) {
                                        ?>
                                        <option value="<?=$txn_type?>"><?=$txn_name?></option>
                                    <?php } ?>
                                </select>
                            </div>&nbsp;&nbsp;
                            
                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>

                    <table class="table mb-0 table-bordered table-striped" id="datatable-ajax-page">
                        <thead>
                            <tr>
                                <th>S.No.</th>
                                <th>Franchise Name</th>
                                <th>Product Name</th>
                                <th>Qty</th>
                                <th>P.V.</th>
                                <th>Txn Type</th>
                                 <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="3" class="text-right">Total</td>
                                <td colspan="" class="text-left" id="tfootTotal">  </td>
                                <td colspan=""  class="text-left" id="tfootTotal1">  </td>
                                <td colspan="2"  class="text-left" >  </td>
                            </tr> 
                        </tfoot>
                    </table>
                    <?php //echo $pager->renderFullNav();        ?>  
                </div>
            </div>
        </div> <!-- end col -->
    </div>
    <!--table content ends here-->
</div>
<script type="text/javascript">
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            ajax: {
                url: "report/stock_detail_report_json.php",
                type: "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                "dataSrc": function (json) {
                    $("#tfootTotal").text(json.total);
                    $("#tfootTotal1").text(json.total_pv);
                    return json.data;
                },
            },
            processing: true,
            serverSide: true,
            pageLength: 500,
            lengthMenu: [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            dom: 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            columns: [
                {data: "sno"},
                {data: "store_name"},
                {data: "name"},
                {data: "quantity"},
                {data: "total_pv"},
                {data: "txn_type"},
                {data: "create_datetime"},
            ],
        }
        );
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        table.on('xhr', function () {
            start = table.ajax.json().start;
        });
    });


</script>
<?php
include('footer.php');
?>