ALTER TABLE `franchise` ADD `refer_id` BIGINT NULL DEFAULT NULL AFTER `datetime`;

ALTER TABLE `product` CHANGE `sgst` `gst_tax_id` INT NULL DEFAULT NULL;
ALTER TABLE `product` ADD `igst_tax_id` INT NULL DEFAULT NULL AFTER `gst_tax_id`;
ALTER TABLE `product` CHANGE `date` `datetime` DATETIME NOT NULL;
ALTER TABLE `product` ADD `status` TINYINT NULL DEFAULT '0' AFTER `hsn_code`;
ALTER TABLE `product` CHANGE `hsn_code` `hsn_code` VARCHAR(40) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT '';
ALTER TABLE `product` ADD `description` VARCHAR(255) NULL DEFAULT NULL AFTER `hsn_code`, ADD `unit` VARCHAR(255) NULL DEFAULT NULL AFTER `description`;

ALTER TABLE `invoice` ADD `tax_type` VARCHAR(50) NULL DEFAULT NULL AFTER `source`;

ALTER TABLE `product_sale` ADD `cgst_rate` DECIMAL(11,2) NULL DEFAULT NULL AFTER `pv`, ADD `sgst_rate` DECIMAL(11,2) NULL DEFAULT NULL AFTER `cgst_rate`, ADD `igst_rate` DECIMAL(11,2) NULL DEFAULT NULL AFTER `sgst_rate`, ADD `hsn_or_sac` VARCHAR(255) NULL DEFAULT NULL AFTER `igst_rate`;

ALTER TABLE `product_sale` ENGINE=INNODB;


CREATE TABLE `franchise_invoice` (
  `id` int(11) NOT NULL,
  `admin_fid` int(11) DEFAULT NULL,
  `fid` bigint(20) NOT NULL,
  `invoice_number` varchar(255) NOT NULL DEFAULT '',
  `reference_number` varchar(255) DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `payment_term` varchar(255) DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `sales_person_id` int(11) DEFAULT 0,
  `billing_address` varchar(255) DEFAULT '',
  `billing_city` varchar(255) DEFAULT '',
  `billing_state` varchar(255) DEFAULT '',
  `billing_zip_code` varchar(50) DEFAULT '',
  `billing_country` varchar(50) DEFAULT '',
  `shipping_address` varchar(255) DEFAULT '',
  `shipping_city` varchar(255) DEFAULT '',
  `shipping_state` varchar(255) DEFAULT '',
  `shipping_zip_code` varchar(50) DEFAULT '',
  `shipping_country` varchar(50) DEFAULT '',
  `discount_type` tinyint(4) DEFAULT 0 COMMENT '(percentage, value)',
  `discount_value` decimal(20,2) DEFAULT 0.00,
  `discount` decimal(20,2) DEFAULT 0.00,
  `sub_total` decimal(20,2) DEFAULT 0.00,
  `total_taxable_amount` decimal(20,2) DEFAULT 0.00,
  `total_tax` decimal(20,2) DEFAULT 0.00,
  `shipping_charge` decimal(20,2) DEFAULT 0.00,
  `adjustment` decimal(20,2) DEFAULT 0.00,
  `total` decimal(20,2) DEFAULT 0.00,
  `note` varchar(1000) DEFAULT '',
  `terms_and_condition` varchar(1000) DEFAULT '',
  `balance` decimal(20,2) DEFAULT 0.00,
  `total_item` decimal(20,2) DEFAULT NULL,
  `create_datetime` datetime NOT NULL DEFAULT current_timestamp(),
  `status` varchar(20) NOT NULL DEFAULT '' COMMENT '1=>paid, 2=>partially paid, 3=>sent, 4=>overdue, 5=>draft',
  `total_pv_amount` decimal(20,2) DEFAULT 0.00,
  `source` varchar(255) DEFAULT NULL,
  `tax_type` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
ALTER TABLE `franchise_invoice`
  ADD PRIMARY KEY (`id`);
ALTER TABLE `franchise_invoice`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

CREATE TABLE `franchise_product_sale` (
  `rec_id` int(11) NOT NULL,
  `admin_fid` int(11) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `fid` int(11) DEFAULT NULL,
  `quantity` decimal(11,2) DEFAULT 0.00,
  `pv_amount` decimal(11,2) DEFAULT NULL,
  `pcost` decimal(11,2) DEFAULT 0.00,
  `product_rate` decimal(20,2) DEFAULT 0.00,
  `tax_percent` decimal(11,2) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `datetime` datetime DEFAULT NULL,
  `status` tinyint(4) DEFAULT 0,
  `invoice_id` bigint(20) DEFAULT NULL,
  `item_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_amount` decimal(20,2) DEFAULT 0.00,
  `cgst_rate` decimal(11,2) DEFAULT NULL,
  `sgst_rate` decimal(11,2) DEFAULT NULL,
  `igst_rate` decimal(11,2) DEFAULT NULL,
  `hsn_or_sac` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
ALTER TABLE `franchise_product_sale`
  ADD PRIMARY KEY (`rec_id`);
ALTER TABLE `franchise_product_sale`
  MODIFY `rec_id` int(11) NOT NULL AUTO_INCREMENT;

CREATE TABLE `stock` (
  `id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `fid` int(11) NOT NULL DEFAULT 1,
  `module_id` int(11) NOT NULL COMMENT '1=>Admin Purchase, 2=>Admin Sale, 3=>Franchise Purchase, 4=> Franchise Sale',
  `module_record_id` bigint(20) NOT NULL,
  `module_item_record_id` bigint(20) DEFAULT NULL,
  `quantity` decimal(20,2) DEFAULT NULL,
  `create_by` int(11) NOT NULL,
  `create_datetime` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
ALTER TABLE `stock`
  ADD PRIMARY KEY (`id`);
ALTER TABLE `stock`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;