<?php
$title = "Fund Transfer Report";
include 'header.php';
//include_once('lib/ps_pagination.php');
$uid = $_SESSION['userid'];
$datetime = date('Y-m-d H:i:s');
if ($master_is_transaction_password && !isset($_SESSION['e_wallet'])) {
    redirect('./transaction_password.php?url=fund_transfer.php');
}
//otp_authenticate("fund_transfer.php");
?>

<div class="container-fluid">

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Fund Transfer</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Payments</a></li>
                    <li class="breadcrumb-item active">Fund Transfer Report</li>
                </ol>
            </div>
        </div>
    </div>
    <?php
//    $total_closed_amount = mysqli_fetch_object(mysqli_query($connection, "SELECT sum(remaining_amount) as total_amount FROM `transaction` WHERE `uid`='" . $uid . "' AND status='1' AND remaining_amount > '0' AND txn_mode='0' "))->total_amount;
//    $total_unclosed_amount = mysqli_fetch_object(mysqli_query($connection, "SELECT sum(remaining_amount) as total_amount FROM `transaction` WHERE `uid`='" . $uid . "' AND status='0'  AND remaining_amount > '0' AND txn_mode='0'   "))->total_amount;
    ?>
    
<?php echo getMessage(); ?>
    <!-- end row -->
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <form name="form" id="form" action="fund_transfer_model.php" method="post">
                        <div class="form-group row" >
                            <label class="col-sm-2 col-form-label" id="fund_transfer_type">Fund Use Type <span>*</span></label>
                            <div class="col-sm-6">

                                <label class="radio-inline">
                                    <input type="radio" name="fund_transfer_type" value="FUND_TRANSFER" checked onchange="fund_transfer_or_topup(this.value)"> Fund Transfer 
                                </label>
                                <?php if(!$master_is_pin_system && $master_is_fund_transfer_topup) :?>
                                <label class="radio-inline">
                                    <input type="radio" name="fund_transfer_type" value="TOPUP" onchange="fund_transfer_or_topup(this.value)"> Topup (Activate) Id
                                </label>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="wallet_id">Select Wallet Type <span>*</span></label>
                            <div class="col-sm-10">
                                <select class="custom-select" name="wallet_id" id="wallet_id" required="required" onchange="if (this.value == '<?=$master_payout_wallet_id?>') {
                                            $('#recipient_wallet_type_field').css('display', 'block');
                                        } else {
                                            $('#recipient_wallet_type_field').css('display', 'none');
                                        }">
                                            <option value="">Select Wallet</option>
                                    <?php
                                foreach ($master_fund_transfer_wallet_id_array as $wallet_id) { ?>
                                <option value="<?=$wallet_id ?>" ><?php echo $master_wallet_array[$wallet_id]['name']." (Balance: ". get_wallet_amount($uid, $wallet_id, $datetime).") "; ?></option>
                                <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="uid">Enter User Id </label>
                            <div class="col-sm-10">

                                <input class="form-control" type="text" name="login_id" id="uid" onblur="find_name(this.value);" required="required" maxlength="200">
                                <span id="u_name"></span></br>
                                <!--                                Note: You can transfer fund from Main wallet to self fund wallet by entering your user Id.-->
                            </div>
                        </div>
                        <div id="fund_transfer_content">
                            <div class="form-group row" style="display: none;" id="recipient_wallet_type_field">
                                <label class="col-sm-2 col-form-label" for="recipient_wallet_type">Recipient Wallet <span>*</span></label>
                                <div class="col-sm-6">

                                    <select class="custom-select" name="recipient_wallet_type" id="recipient_wallet_type" required="required">
                                        <option value="fund_wallet" selected="selected">Unclosed Wallet </option>
                                        <option value="primary_wallet" >Closed Wallet </option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="amount">Enter Amount  </label>
                                <div class="col-sm-10">
                                    <input class="form-control" type="number" name="amount" id="amount"  step="any">
                                    Amount must be less than or equal to Wallet amount.
                                </div>
                            </div>
                            <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="description">Description  </label>
                            <div class="col-sm-10">
                                <textarea class="form-control" name="description" id="description" ></textarea>
                            </div>
                        </div>
                        </div>
                        <div id="topup_content" style="display: none;">
                            <div class="form-group row">
                                <label for="pin"  class="col-sm-2 col-form-label" >Select Pin Type <span>*</span></label>
                                <div class="col-sm-6">
                                    <select class="custom-select" name="type" id="type" required="required">
                                        <option>Select Package</option>
                                          <?php
                                        $result_pin_package = mysqli_query($connection, "SELECT id, package_name, package_amount, pin_length FROM pin_package WHERE package_amount !='0' ");
                                        while ($pin_type = mysqli_fetch_object($result_pin_package)) {
                                            ?>
                                            <option value="<?php echo $pin_type->id; ?>" >
    <?php echo "Package - $pin_type->package_amount "; ?></option>
    <?php
}
?>
                                    </select>
                                </div>
                            </div>
                        </div>



                        <div class="form-group">
                            <div>
                                <button style="position: relative; left: 180px;" name="submit" type="submit" id="submit" value="Transfer" class="btn btn-primary waves-effect waves-light">
                                    Submit
                                </button>
                            </div>
                        </div>

                    </form>
                </div>

            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->


</div> <!-- container-fluid -->


<script>


    function find_name(refer_id) {
//    alert('refer_id'+refer_id);
        var returnValue = false;
        $.ajax({
            url: "../get_sponser.php",
            data: {'refer_id': refer_id},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    returnValue = false;
                    $("#submit").attr("disabled", true);
                    $("#u_name").html('<b style="color:red">Invalid Name</b>');
                } else {
                    returnValue = true;
                    $("#u_name").html('<b style="color:green">' + data.name + ' - Valid Name</b>');
                    $("#submit").removeAttr("disabled");
                }
            }
        });
        return returnValue;
    }
    function fund_transfer_or_topup(fieldValue) {
        if (fieldValue == 'FUND_TRANSFER') {
            $('#fund_transfer_content').css('display', 'block');
            $('#topup_content').css('display', 'none');
        } else {
            $('#fund_transfer_content').css('display', 'none');
            $('#topup_content').css('display', 'block');
            
        }
    }
    
</script>
<?php include('footer.php'); ?>
