/* 
 * crypto web3 my lib 23rd jun 2023
 */

var usdtABI = [{"constant": false, "inputs": [{"name": "_to", "type": "address"}, {"name": "_value", "type": "uint256"}], "name": "transfer", "outputs": [{"name": "", "type": "bool"}], "payable": false, "stateMutability": "nonpayable", "type": "function"}, {"constant": true, "inputs": [{"name": "_owner", "type": "address"}], "name": "balanceOf", "outputs": [{"name": "balance", "type": "uint256"}], "payable": false, "stateMutability": "view", "type": "function"}];

$(document).ready(function () {
    $("#connect_wallet_crypto_btn").click(function(){
    if (crypto_currency == 'TRX' || crypto_currency == 'USDT.TRC20') {
        if (window.tronWeb && window.tronWeb.defaultAddress.base58) {
            $("#crypto_topup_wallet_connect").css({display: 'block'});
            $("#crypto_topup_wallet_connect_error").css({display: 'none'});

            if (crypto_currency === 'TRX') {
                getBalanceTRX();
            } else if (crypto_currency === 'USDT.TRC20') {
                getBalanceUsdtTRC20();
            }
        } else {
            $("#crypto_topup_wallet_connect").css({display: 'none'});
            $("#crypto_topup_wallet_connect_error").css({display: 'block'});
        }
    } else if (crypto_currency == 'USDT.ERC20' || crypto_currency == 'USDT.BEP20' || crypto_currency == 'PUSDT.ERC20') {

        //if (window.ethereum && (window.ethereum.isConnected() || window.ethereum.isTrustWallet)) {
        if (window.ethereum) {
            $("#crypto_topup_wallet_connect").css({display: 'block'});
            $("#crypto_topup_wallet_connect_error").css({display: 'none'});
            window.ethereum
                    .request({method: 'net_version'})
                    .then(networkId => {
                        // networkId represents the network the user is connected to
                        //console.log('Connected to network ==========:', networkId);

                        const {contractAddress, amountDecimal, networkChainId} = getCurrencyData(crypto_currency);
                        //console.log(networkId == networkChainId);

                        if (networkId == networkChainId) {
                            getBalanceUsdtEthereum(contractAddress, amountDecimal);
                        } else {
                            $("#topup_crypto_btn").attr({'disabled': true});
                            alert(`Connect to right ${crypto_currency} blockchain to connect to this app!`);
                        }
                    })
                    .catch(error => {
                        console.error('Error retrieving network information:', error);
                    });
        } else {
            $("#crypto_topup_wallet_connect").css({display: 'none'});
            $("#crypto_topup_wallet_connect_error").css({display: 'block'});
        }
    }
    /*  
     else if (crypto_currency == 'USDT.BEP20' && window.ethereum &&  (window.ethereum.isConnected() || window.ethereum.isTrustWallet)) {
     $("#crypto_topup_wallet_connect").css({display: 'block'});
     $("#crypto_topup_wallet_connect_error").css({display: 'none'});
     window.ethereum
     .request({ method: 'net_version' })
     .then(networkId => {
     // networkId represents the network the user is connected to
     console.log('Connected to network:', networkId);
     if(networkId==chain_id_bnb){
     getbalanceUSDT_BSC();
     }
     else{
     alert('Connect to Correct Network ID to See Balance');
     }
     })
     .catch(error => {
     console.error('Error retrieving network information:', error);
     });
     } else if (crypto_currency == 'PUSDT.ERC20' && window.ethereum &&  (window.ethereum.isConnected() || window.ethereum.isTrustWallet)) {
     $("#crypto_topup_wallet_connect").css({display: 'block'});
     $("#crypto_topup_wallet_connect_error").css({display: 'none'});
     window.ethereum
     .request({ method: 'net_version' })
     .then(networkId => {
     // networkId represents the network the user is connected to
     console.log('Connected to network:', networkId);
     if(networkId==chain_id_matic){
     getbalanceUSDT_POLYGON();
     }
     else{
     alert('Connect to Correct Network ID to See Balance');
     }
     })
     .catch(error => {
     console.error('Error retrieving network information:', error);
     });
     }
     */
    else
    {
        $("#crypto_topup_wallet_connect").css({display: 'none'});
        $("#crypto_topup_wallet_connect_error").css({display: 'block'});
    }
});
});

async function getBalanceTRX()
{
    if (window.tronWeb && window.tronWeb.defaultAddress.base58) {
        const senderWalletAddress = window.tronWeb.defaultAddress.base58;
        console.log(senderWalletAddress);
        $("#senderWalletAddress").text(senderWalletAddress);
        //For Trx Balance
        const result = await window.tronWeb.trx.getUnconfirmedBalance(senderWalletAddress);
        const trx_balance = window.tronWeb.fromSun(result);
        $("#senderWalletBalance").text(trx_balance);
        console.log(trx_balance);
    }
}
//setTimeout('getbalance()', 3000); 
async function getBalanceUsdtTRC20()
{
    if (window.tronWeb && window.tronWeb.defaultAddress.base58) {
        const {contractAddress, amountDecimal, networkChainId} = getCurrencyData(crypto_currency);
        const senderWalletAddress = window.tronWeb.defaultAddress.base58;
        // let contract_address="TF17BgPaZYbz8oxbjhriubPDsA7ArKoLX3";
//                let contract_address = contractAddressUsdtTRC20;
        const tronweb = window.tronWeb;
        const contract = await tronWeb.contract().at(contractAddress);
        console.log(contract);
        const usdt_balance = await contract.balanceOf(senderWalletAddress).call();
        const value = usdt_balance / Math.pow(10, amountDecimal)
        $("#senderWalletAddress").text(senderWalletAddress);
        $("#senderWalletBalance").text(value);
        console.log(usdt_balance);

    }
}
//setTimeout('getBalanceUsdtTRC20()', 3000);

async function getBalanceUsdtEthereum(contractAddress, amountDecimal)
{
    if (window.ethereum ) {
        await window.ethereum.request({method: 'eth_requestAccounts'})
                .then(async (accounts) => {
                    const web3 = new Web3(window.ethereum);
                    const usdtContract = new web3.eth.Contract(usdtABI, contractAddress);
                    // console.log(web3);
                    // console.log(accounts[0]);
                    const senderWalletAddress = accounts[0];
                    $("#senderWalletAddress").text(senderWalletAddress);
                    // $('#account_number').val(senderWalletAddress); 
                    // $('#account_number').attr({'readonly':true });

                    usdtContract.methods.balanceOf(senderWalletAddress).call({from: senderWalletAddress})
                            .then(balance => {
                                console.log('USDT Balance:', balance, typeof (balance));
                                $("#senderWalletBalance").text(Number(balance) / Math.pow(10, amountDecimal));
                            });

                }).catch(err => {
            alert(err);
        });
    }
}
/*  
 async function getbalanceUSDT_BSC()
 {
 await window.ethereum.request({ method: 'eth_requestAccounts' })
 .then(async(accounts) => {
 const web3 = new Web3(window.ethereum);
 const usdtContract = new web3.eth.Contract(usdtABI, contractAddressUsdtBEP20);
 var account = accounts[0]; 
 $("#senderWalletAddress_BSC").val(account);
 usdtContract.methods.balanceOf(account).call({ from: account })
 .then(balance => {
 console.log('USDT Balance:', balance);
 $("#usdtbalance_BSC").val(Number(balance)/1000000000000000000);
 });
 })
 .catch(err => {
 alert(err)
 });
 
 }
 
 async function getbalanceUSDT_POLYGON()
 {
 await window.ethereum.request({ method: 'eth_requestAccounts' })
 .then(async(accounts) => {
 const web3 = new Web3(window.ethereum);
 console.log(contractAddressPUsdtERC20);
 const usdtContract = new web3.eth.Contract(usdtABI, contractAddressPUsdtERC20);
 var account = accounts[0]; 
 $("#senderWalletAddress_MATIC").val(account);
 usdtContract.methods.balanceOf(account).call({ from: account })
 .then(balance => {
 console.log('USDT Balance:', balance);
 $("#usdtbalance_MATIC").val(Number(balance)/1000000);
 });
 })
 .catch(err => {
 alert(err)
 });
 
 }
 
 */

async function sendTRX(amount, recieverAddress)
{
    if (window.tronWeb && window.tronWeb.defaultAddress.base58)
    {

        const senderWalletAddress = window.tronWeb.defaultAddress.base58;
        console.log(recieverAddress);
        console.log(senderWalletAddress);

        var tronweb = window.tronWeb
        var tx = await tronweb.transactionBuilder.sendTrx(recieverAddress, window.tronWeb.toSun(amount), senderWalletAddress)
                .catch((err) => {
                    alert(err);
                    return {isSuccess: false};
                });
        var signedTx = await tronweb.trx.sign(tx);
        var broastTx = await tronweb.trx.sendRawTransaction(signedTx);
        console.log(broastTx);
        return {isSuccess: true, txnHash: broastTx.txid, senderWalletAddress: senderWalletAddress};
//        topup_by_crypto_txn_hash(amount, broastTx.txid, senderWalletAddress);

    } else {
        return {isSuccess: false};
    }


}

async function sendUsdtTRC20(amount, recieverAddress)
{
    let isSuccess = false;
    let txnHash = '';
    let senderWalletAddress = '';

    const {contractAddress, amountDecimal, networkChainId} = getCurrencyData(crypto_currency);
    senderWalletAddress = window.tronWeb.defaultAddress.base58;
    const amt = (amount * Math.pow(10, amountDecimal)).toString();
    const tronweb = window.tronWeb
    // let contract_address="TF17BgPaZYbz8oxbjhriubPDsA7ArKoLX3"; // Jst
//            let contract_address = contractAddressUsdtTRC20; // USDT
    let contract = await tronWeb.contract().at(contractAddress);
    await contract.transfer(recieverAddress, amt).send({feeLimit: 150000000, callValue: 0})
            .then((result) => {
                console.log(result);
                isSuccess = true;
                txnHash = result;
                // senderaddress = senderWalletAddress;

//                topup_by_crypto_txn_hash(amount, result, senderWalletAddress);
                // return {isSuccess: true, txnHash: result, senderWalletAddress: senderWalletAddress};
            })
            .catch((err) => {
                console.log(err)
                // return {isSuccess: false};
            });

    return {isSuccess, txnHash, senderWalletAddress};
}

async function sendUsdtERC20(amount, recieverAddress)
{
    let isSuccess = false;
    let txnHash = '';
    let senderWalletAddress = '';

    const {contractAddress, amountDecimal, networkChainId} = getCurrencyData(crypto_currency);

    await window.ethereum.request({method: 'eth_requestAccounts'})
            .then(async (accounts) => {

                const web3 = new Web3(window.ethereum);
                var amt = (amount * Math.pow(10, amountDecimal)).toString();
                senderWalletAddress = accounts[0];
                const usdtContract = new web3.eth.Contract(usdtABI, contractAddress);
                
                const gasPrice = await web3.eth.getGasPrice();
                // console.log("Current gas price (Wei):", gasPrice);
                const increasedGasPrice = BigInt(gasPrice) + ((BigInt(gasPrice) * BigInt(5)) / BigInt(100)); // Increase by 5%
                const gasLimit = await usdtContract.methods.transfer(recieverAddress, amt.toString()).estimateGas({ from: senderWalletAddress });
                await usdtContract.methods.transfer(recieverAddress, amt)
                        .send({from: senderWalletAddress, gasPrice: increasedGasPrice.toString(), gas: gasLimit})
                        .on('transactionHash', hash => {
                            // busd_bep20 = hash;
                            console.log('Transaction Hash:', hash);
                        })
                        .on('confirmation', (confirmationNumber, receipt) => {
                            console.log('transactionHash:', confirmationNumber.receipt.transactionHash);
//                    console.log('transactionHash:', confirmationNumber.receipt.transactionHash);
//                            topup_by_crypto_txn_hash(amount, confirmationNumber.receipt.transactionHash, senderWalletAddress);
                            isSuccess = true;
                            txnHash = confirmationNumber.receipt.transactionHash;
                            // senderaddress =senderWalletAddress;
                            // return {isSuccess: true, txnHash: confirmationNumber.receipt.transactionHash, senderWalletAddress: senderWalletAddress};
                        })
                        .on('error', error => {
                            console.error('Error:', error);
                            // return {isSuccess: false};
                            //isSuccess =false;
                        });
            })
            .catch(err => {
                console.log(err);
                // return {isSuccess: false};
                //isSuccess = false;
            });

    return {isSuccess, txnHash, senderWalletAddress};
}
/*
 async function sendUSDT_erc20(amount, adminAddress)
 {
 await window.ethereum.request({ method: 'eth_requestAccounts' })
 .then(async (accounts) => {
 let amt = amount*1000000;
 var account = accounts[0];
 
 const web3 = new Web3(window.ethereum);
 const usdtContract = new web3.eth.Contract(usdtABI, contractAddressUsdtERC20);
 usdtContract.methods.transfer(adminAddress, amt).send({ from: account })
 .on('transactionHash', hash => {
 console.log('Transaction Hash:', hash);
 })
 .on('confirmation', (confirmationNumber, receipt) => {
 console.log('Confirmation Number:', confirmationNumber);
 console.log('Receipt:', receipt);
 topup_by_crypto_txn_hash(amount, result, account);
 })
 .on('error', error => {
 console.error('Error:', error);
 }); 
 
 }).catch(err => {
 alert(err);
 });
 
 
 }
 
 // var busd_bep20 = '';
 
 
 async function sendUSDT_MATIC_erc20(amount, adminAddress)
 {
 await window.ethereum.request({ method: 'eth_requestAccounts' })
 .then(async (accounts) => {
 
 const web3 = new Web3(window.ethereum);
 var amt = (amount*1000000).toString();
 var account = accounts[0];
 const usdtContract = new web3.eth.Contract(usdtABI, contractAddressPUsdtERC20);
 usdtContract.methods.transfer(adminAddress, amt).send({ from: account })
 .on('transactionHash', hash => {
 console.log('Transaction Hash:', hash);
 })
 .on('confirmation', (confirmationNumber, receipt) => {
 console.log('Confirmation Number:', confirmationNumber);
 console.log('Receipt:', receipt);
 // topup_by_crypto_txn_hash(amount, result, account);
 })
 .on('error', error => {
 console.error('Error:', error);
 });    
 })
 .catch(err => {
 alert(err)
 });
 
 
 }
 */
function getCurrencyData(currency) {
    let contractAddress = '';
    let amountDecimal = '';
    let networkChainId = '';

    if (currency == 'USDT.TRC20') {
        contractAddress = contractAddressUsdtTRC20;
        amountDecimal = 6;
    } else if (currency == 'USDT.ERC20') {
        contractAddress = contractAddressUsdtERC20;
        amountDecimal = 6;
        networkChainId = chain_id_eth;
    } else if (currency == 'USDT.BEP20') {
        contractAddress = contractAddressUsdtBEP20;
        amountDecimal = 18;
        networkChainId = chain_id_bnb;
    } else if (currency == 'PUSDT.ERC20') {
        contractAddress = contractAddressPUsdtERC20;
        amountDecimal = 6;
        networkChainId = chain_id_matic;
    }
    return {contractAddress, amountDecimal, networkChainId};
}